﻿using Syncfusion.Blazor.Charts;
using Syncfusion.Blazor;
using System.Collections.ObjectModel;
using System.Globalization;
using System;
using Syncfusion.Blazor.Charts.Chart.Internal;
using System.Collections.Generic;
using Google.Protobuf.WellKnownTypes;

namespace SFChart.Pages
{
    public partial class ChartComponent
    {

        private System.Threading.Timer? updateTimer = null;
        private DateTime lastMaxCurrentTime = DateTime.MinValue;
        private bool isTooltipEnabled = false;
        private bool isZooming = false;
        private DateTimeOffset zoomStart;
        private DateTimeOffset zoomEnd;
        private Random randomNum = new Random();
        string result = string.Empty;
        public string[] colors = new string[] { "Red", "Green", "Blue", "Gray", "Purple", "Aqua", "Lime", "Orange", "Yellow", "Black" };
        public ChartShape[] chartShapes = new ChartShape[] { ChartShape.Circle, ChartShape.Rectangle, ChartShape.Diamond, ChartShape.Triangle, ChartShape.Pentagon, ChartShape.InvertedTriangle };
        private Random rnd = new Random();
        public bool boolvalue { get; set; } = false;
        private DateTime TrendStart { get; set; } = DateTime.Now.AddMinutes(-20);
        private DateTime TrendEnd { get; set; } = DateTime.Now.AddSeconds(120);
        public ObservableCollection<ChartData> ChartDatas = new ObservableCollection<ChartData>();
        public void ShowOrHideMarker()
        {
            boolvalue = !boolvalue;
            StateHasChanged();

        }
        public void EnableTooltip()
        {
            this.HistoryUpdate();
            //isTooltipEnabled = !isTooltipEnabled;
            StateHasChanged();
        }

        protected override async Task OnInitializedAsync()
        {
            ChartDatas.Add(new ChartData { TName = "1", Min = 0, Max = 100, Marker = chartShapes[0], TColour = colors[0] });
            ChartDatas.Add(new ChartData { TName = "2", Min = 10, Max = 110, Marker = chartShapes[1], TColour = colors[1] });
            ChartDatas.Add(new ChartData { TName = "3", Min = 0, Max = 100, Marker = chartShapes[2], TColour = colors[2] });
            ChartDatas.Add(new ChartData { TName = "4", Min = 20, Max = 120, Marker = chartShapes[3], TColour = colors[3] });
            ChartDatas.Add(new ChartData { TName = "5", Min = 20, Max = 120, Marker = chartShapes[4], TColour = colors[4] });
            for (int i = 0; i < ChartDatas.Count; i++)
            {
                this.AssignTagRenderingInputs(i, ChartDatas[i], ChartDatas.Count);
            }

           await this.HistoryUpdate();
            // Starting live update in the chart.
            //this.updateTimer = new System.Threading.Timer(async (e) => { await this.UpdateTimer(null); }, null, 0, 1000);
        }
        private void UpdateTrendWindow(DateTime time)
        {
            int sec = 0;
            int r = time.Second % 10;
            if (r > 0)
            {
                sec = 10 - r;
            }

            var end = new DateTime(time.Year, time.Month, time.Day, time.Hour, time.Minute, time.Second).AddSeconds(sec);

            this.TrendEnd = end.AddSeconds(120);

            this.TrendStart = end.AddMinutes(-20);
        }
        private async Task UpdateTimer(object? state)
        {
            this.updateTimer?.Change(Timeout.Infinite, Timeout.Infinite);

            var now = DateTime.Now;

            if (this.TrendEnd.Ticks < this.lastMaxCurrentTime.Ticks)
            {
                this.UpdateTrendWindow(now);
                await this.HistoryUpdate().ContinueWith(t =>
                {
                    this.InvokeAsync(this.StateHasChanged);
                    this.updateTimer?.Change(1000, 1000);
                }).ConfigureAwait(false);
            }
            else
            {
                await this.ValueUpdate().ContinueWith(t =>
                {
                    this.updateTimer?.Change(1000, 1000);
                }).ConfigureAwait(false);
            }
        }
        private async Task ValueUpdate()
        {
            foreach (var chartData in ChartDatas)
            {
                chartData.CurrentDataPoints.Add(new ChartDataPoint
                {
                    Time = DateTime.Now,
                    CPU_Usage = randomNum.Next(30, 80)
                });
                if (this.lastMaxCurrentTime < chartData.CurrentLastUpdateTime)
                {
                    this.lastMaxCurrentTime = chartData.CurrentLastUpdateTime;
                }
            }

        }

        private async Task HistoryUpdate()
        {
            foreach (var chartData in ChartDatas)
            {
                chartData.DataPoints = populateHistory();
                chartData.CurrentDataPoints.Clear();
                chartData.CurrentDataPoints.Add(chartData.DataPoints.OrderBy(x => x.Time).Last());
            }
            await SleeveUpdate();
        }

        private List<ChartDataPoint> populateHistory()
        {
            List<ChartDataPoint> result = new List<ChartDataPoint>();

            for (int i = 100; i > 0; i--)
                result.Add(new ChartDataPoint
                {
                    Time = DateTime.Now.AddMilliseconds(-(3600 * i)),
                    CPU_Usage = randomNum.Next(50, 70)
                });
            return result;
        }

        private async Task SleeveUpdate()
        {
            foreach (var chartData in ChartDatas)
            {
                chartData.SleeveDataPoints = populateSleeve();
            }
        }

        private List<ChartDataPoint> populateSleeve()
        {
            List<ChartDataPoint> result = new List<ChartDataPoint>();

            for (int i = 1000; i > 0; i--)
                result.Add(new ChartDataPoint
                {
                    Time = DateTime.Now.AddMilliseconds(-(3600 * i)),
                    CPU_Usage = randomNum.Next(10, 90)
                });
            return result;
        }

        public void ScrollChangeEvent(ScrollEventArgs args)
        {
            ////Console.WriteLine("scrollchange");
        }
        public void OnZoomingStartEvent(ZoomingEventArgs args)
        {
            this.isZooming = true;
            //Console.WriteLine("Zoom Start");
            // Here, you can customize your code.        
        }
        public void OnZoomingEndEvent(ZoomingEventArgs args)
        {
            var axis = args.AxisCollection;
            if (axis.Any(x => x.ZoomFactor != 1))
            {
                this.isZooming = true;
            }
            else
            {
                this.isZooming = false;
            }
            //Console.WriteLine("Zoom End");

            // Here, you can customize your code.

        }
        public void OnZoomingEvent(ZoomingEventArgs args)
        {
            //Console.WriteLine("Zoom ing");

            ////var axis = args.AxisCollection;
            ////axis.ForEach(x =>
            ////{
            ////    var axisrange = x.AxisRange;
            ////    var zoomPos = x.ZoomPosition;
            ////    var axisName = x.AxisName;
            ////    var zoomfactor = x.ZoomFactor;
            ////});
            // Here, you can customize your code.
        }

        public async void AxisActualRangeEvent(AxisRangeCalculatedEventArgs args)
        {           
            Console.WriteLine(TrendEnd);
            Console.WriteLine(TrendStart);
            var maxi = DateTimeOffset.FromUnixTimeMilliseconds((long)args.Maximum);
            var mini = DateTimeOffset.FromUnixTimeMilliseconds((long)args.Minimum);
            if (this.isZooming && args.AxisName == "PrimaryXAxis" && !(this.zoomEnd == maxi && this.zoomStart == mini))
            {
                this.zoomEnd = maxi;
                this.zoomStart = mini;
                await SleeveUpdate();
            }
            Console.WriteLine("axis");
            Console.WriteLine(args.AxisName);
            if (args.Interval < 0.5 && args.AxisName != "PrimaryXAxis")
            {
                args.Interval = 0.5;
            }
            //DateTimeOffset dateTimeOffset = DateTimeOffset.Now; // Get the current DateTimeOffset
            //DateTime universalTime = dateTimeOffset.UtcDateTime; // Get the equivalent UTC DateTime

            //DateTime customerMin = TrendStart.ToUniversalTime();
            //DateTime customerMax = TrendEnd.ToUniversalTime();

            //double milliseconds = (TrendEnd - new DateTime(1970, 1, 1)).TotalMilliseconds;
            //double milliseconds2 = (TrendStart - new DateTime(1970, 1, 1)).TotalMilliseconds;

            //var end = DateTimeOffset.FromUnixTimeMilliseconds((long)milliseconds);
            //var start = DateTimeOffset.FromUnixTimeMilliseconds((long)milliseconds2);

            //var cusMin = start.UtcDateTime;
            //var cusMax = end.UtcDateTime;
            //Console.WriteLine(TrendEnd);
            //Console.WriteLine(cusMax);

            if (args.AxisName == "PrimaryXAxis")
            {
                 
                 maxi = DateTimeOffset.FromUnixTimeMilliseconds((long)args.Maximum);
                 DateTimeOffset getUtcMax = maxi.UtcDateTime;

                 mini = DateTimeOffset.FromUnixTimeMilliseconds((long)args.Minimum);
                 DateTime getUtcMin = mini.UtcDateTime;
            }
        }

        private void AssignTagRenderingInputs(int index, ChartData tag, int totaltags = 1)
        {
            tag.XPos = GetXPixel(index, totaltags);
            tag.YLable = (index + 1).ToString(CultureInfo.CurrentCulture);
        }
        private static double GetXPixel(int index, int totaltags)
        {
            var temp = totaltags - index;
            return 20 * (temp + temp - 1.2);
        }
        ////public void OnZoomingStartEvent(ZoomingEventArgs args)
        ////{
        ////    // Here, you can customize your code.
        ////}
    }


    public class ChartDataPoint
    {
        public DateTime Time { get; set; }
        public double CPU_Usage { get; set; }
    }
    public class ChartData
    {
        public double Min { get; set; }
        public double Max { get; set; }
        public List<ChartDataPoint> DataPoints { get; set; } = new List<ChartDataPoint>();
        public List<ChartDataPoint> SleeveDataPoints { get; set; } = new List<ChartDataPoint>();

        public ObservableCollection<ChartDataPoint> CurrentDataPoints { get; set; } = new ObservableCollection<ChartDataPoint>();
        public string TName { get; set; }
        public double XPos { get; set; }
        public string YLable { get; set; } = string.Empty;
        public string TColour { get; set; }
        public ChartShape Marker { get; set; }
        public DateTime CurrentLastUpdateTime
        {
            get
            {
                return this.CurrentDataPoints.Count > 0 ? this.CurrentDataPoints.Last().Time : DateTime.MinValue;
            }
        }
        public void SharedTooltipEvent()
        {
            // Here, you can customize your code.
        }

        private void TooltipRender(TooltipRenderEventArgs args)
        {
            args.Text = args.Text.IndexOf("-") > 0 ? args.Text.Replace("-", "") : args.Text;
            args.Text = args.Text + " " + "<b>kg</b>";
        }

    }

}
